/*
 * @brief Secondary loader main application code
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "chip.h"
#include "sl_protocol.h"


#define LEDSAVAIL 3
static const uint8_t ledBits[LEDSAVAIL] = {12, 16, 27};

void SysTick_Handler(void)
{
	Chip_GPIO_SetPinToggle(LPC_GPIO_PORT, 0, ledBits[0]);
}

extern SL_PINSETUP_T PINONLYCFGTABLEFLASH;

int main(void)
{
	static uint32_t i;
	SL_PINSETUP_T *psetup = (SL_PINSETUP_T*)&PINONLYCFGTABLEFLASH; 
	SCB->VTOR = 0x00002000;
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_GPIO);
	for (i = 0; i < LEDSAVAIL; i++) {
		Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, ledBits[i]);
		Chip_GPIO_SetPinState(LPC_GPIO_PORT, 0, ledBits[i], true);
	}
	SystemCoreClockUpdate();
	SysTick_Config(SystemCoreClock / 10);
	for(i = 0; i < 0x100000; i++);
	//bootSecondaryLoader(psetup);
	while(1){
//		__WFI();
	}
	return 0;
}
